
IF EXISTS (SELECT  * FROM SYS.TRIGGERS WHERE NAME = 'TRG_LINX_IO_PROD_ATRIBUTO')
BEGIN
	DROP TRIGGER TRG_LINX_IO_PROD_ATRIBUTO
END 
GO 

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20220614 
'Job.................:  
'Nome................: TRG_LINX_IO_PROD_ATRIBUTO
'Projeto............:  Commerce 
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 14/06/2022
'Alterado por........: Marcos Barros
'Criado por..........:    
'=======================================================================================
FARMAGOI-24164
*/
CREATE TRIGGER TRG_LINX_IO_PROD_ATRIBUTO ON LINX_IO_PROD_ATRIBUTO
FOR INSERT, UPDATE, DELETE 
AS
  DECLARE @CD_PROD INT
  DECLARE @CD_EMP INT

  IF EXISTS(SELECT TOP 1 CD_PROD FROM INSERTED)
  	SELECT @CD_PROD = CD_PROD, @CD_EMP = CD_EMP FROM INSERTED;
  ELSE
    SELECT @CD_PROD = CD_PROD, @CD_EMP = CD_EMP FROM DELETED;

  UPDATE EST_PROD SET  DT_ULT_ATU = GETDATE()
	WHERE CD_PROD = @CD_PROD  AND CD_EMP = @CD_EMP

  UPDATE LINX_IO_PROD SET   DT_ULT_ATU = GETDATE()
	WHERE CD_PROD = @CD_PROD AND CD_EMP = @CD_EMP
